/*
 * Decompiled with CFR 0.152.
 */
package me.leonardjackson.jumpglider.items;

import me.leonardjackson.jumpglider.JumpGlider;
import me.leonardjackson.jumpglider.init.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class ItemJumpGliderArmor
extends ItemArmor {
    public boolean isGliding;
    public double letGo;

    public ItemJumpGliderArmor(String unlocalizedName, ItemArmor.ArmorMaterial material, int index, EntityEquipmentSlot armorSlot) {
        super(material, index, armorSlot);
        this.func_77655_b(unlocalizedName);
        this.setRegistryName(unlocalizedName);
        this.func_77637_a(JumpGlider.CREATIVE_TAB);
    }

    public String func_77658_a() {
        return String.format("item.%s", this.getUnwrappedUnlocalizedName(super.func_77658_a()));
    }

    public String func_77667_c(ItemStack itemStack) {
        return String.format("item.%s", this.getUnwrappedUnlocalizedName(super.func_77658_a()));
    }

    protected String getUnwrappedUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(46) + 1);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot armorSlot, String layer) {
        String name = this.getUnwrappedUnlocalizedName(super.func_77658_a());
        name = name.substring(0, name.indexOf(95));
        return String.format("%s:textures/models/armor/%s_layer_%d.png", "jumpglider", name, armorSlot.func_188452_c() == 2 ? 2 : 1);
    }

    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        ModelBiped armorModel = ModItems.armorModels.get((Object)this);
        if (armorModel != null) {
            armorModel.field_78116_c.field_78806_j = armorSlot.func_188452_c() == 0;
            armorModel.field_178720_f.field_78806_j = false;
            armorModel.field_78115_e.field_78806_j = armorSlot.func_188452_c() == 1 || armorSlot.func_188452_c() == 2;
            armorModel.field_178723_h.field_78806_j = armorSlot.func_188452_c() == 1;
            armorModel.field_178724_i.field_78806_j = armorSlot.func_188452_c() == 1;
            armorModel.field_178721_j.field_78806_j = armorSlot.func_188452_c() == 2 || armorSlot.func_188452_c() == 3;
            armorModel.field_178722_k.field_78806_j = armorSlot.func_188452_c() == 2 || armorSlot.func_188452_c() == 3;
            armorModel.field_78091_s = entityLiving.func_70631_g_();
            armorModel.field_78093_q = entityLiving.func_184218_aH();
            armorModel.field_78117_n = entityLiving.func_70093_af();
        }
        return armorModel;
    }

    private void getPotionEffect(EntityPlayer player, Potion potion, int amplifier) {
        if (player.func_70660_b(potion) == null || player.func_70660_b(potion).func_76459_b() <= 1) {
            player.func_70690_d(new PotionEffect(potion, 2, 1, false, false));
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        Potion haste = Potion.func_188412_a((int)3);
        Potion speed = Potion.func_188412_a((int)1);
        if (itemStack.func_77973_b() == ModItems.jumpGliderHelm) {
            this.getPotionEffect(player, haste, 1);
        }
        if (itemStack.func_77973_b() == ModItems.jumpGliderWings) {
            boolean inAir = !player.field_70122_E && player.field_70181_x < 0.0 && !player.func_70090_H();
            boolean sneaking = player.func_70093_af();
            double horizontalSpeed = 0.08;
            double verticalSpeed = 0.5;
            if (inAir && sneaking) {
                player.field_70181_x *= verticalSpeed;
                double x = Math.cos(Math.toRadians(player.field_70759_as + 90.0f)) * horizontalSpeed;
                double z = Math.sin(Math.toRadians(player.field_70759_as + 90.0f)) * horizontalSpeed;
                player.field_70159_w += x;
                player.field_70179_y += z;
                player.field_70143_R = 0.0f;
            }
            this.isGliding = true;
        }
        if (itemStack.func_77973_b() == ModItems.jumpGliderLeggings) {
            this.getPotionEffect(player, speed, 1);
        }
        if (itemStack.func_77973_b() == ModItems.jumpGliderBoots && player.field_70160_al) {
            EntityPlayerSP singlePlayer = Minecraft.func_71410_x().field_71439_g;
            double addY = 0.05;
            if (singlePlayer.field_71158_b.field_78901_c) {
                singlePlayer.field_70181_x += addY * 3.0;
                this.letGo = player.field_70163_u;
            }
        }
        ItemStack jumpBoots = player.func_184582_a(EntityEquipmentSlot.FEET);
        ItemStack leggings = player.func_184582_a(EntityEquipmentSlot.LEGS);
        player.field_70138_W = jumpBoots != null && jumpBoots.func_77973_b() == ModItems.jumpGliderBoots && leggings != null && leggings.func_77973_b() == ModItems.jumpGliderLeggings ? 1.0023f : 0.6f;
        super.onArmorTick(world, player, itemStack);
    }
}

