/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.block;

import com.google.common.collect.Lists;
import java.util.List;
import net.malisis.core.MalisisCore;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.renderer.DefaultRenderer;
import net.malisis.core.renderer.MalisisRendered;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.icon.provider.IIconProvider;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.MBlockState;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.core.util.chunkcollision.ChunkCollision;
import net.malisis.core.util.chunkcollision.IChunkCollidable;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.renderer.BigDoorRenderer;
import net.malisis.doors.tileentity.BigDoorTileEntity;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@MalisisRendered(block=BigDoorRenderer.class, item=DefaultRenderer.Item.class)
public class BigDoor
extends MalisisBlock
implements ITileEntityProvider,
IChunkCollidable {
    private AxisAlignedBB defaultBoundingBox = new AxisAlignedBB(0.0, 0.0, 0.8125, 4.0, 5.0, 1.0);

    public BigDoor(Type type) {
        super(Material.field_151575_d);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.setName(type.name);
        this.func_149647_a(MalisisDoors.tab);
        this.addComponent((IComponent)new DirectionalComponent());
        if (MalisisCore.isClient()) {
            this.addComponent((IComponent)BigDoorIconProvider.get(type));
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        ChunkCollision.get().replaceBlocks(world, new MBlockState((IBlockAccess)world, pos));
        BigDoorTileEntity te = (BigDoorTileEntity)((Object)TileEntityUtils.getTileEntity(BigDoorTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        if (te != null) {
            te.setFrameState(MBlockState.fromNBT((NBTTagCompound)stack.func_77978_p()));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        BigDoorTileEntity te = (BigDoorTileEntity)((Object)TileEntityUtils.getTileEntity(BigDoorTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        if (te == null) {
            return true;
        }
        te.openOrCloseDoor();
        return true;
    }

    public AxisAlignedBB[] getBoundingBoxes(IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        if (type == BoundingBoxType.PLACEDBOUNDINGBOX) {
            return new AxisAlignedBB[]{this.defaultBoundingBox};
        }
        BigDoorTileEntity te = (BigDoorTileEntity)((Object)TileEntityUtils.getTileEntity(BigDoorTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        if (te == null) {
            return AABBUtils.identities();
        }
        AxisAlignedBB[] aabbs = new AxisAlignedBB[]{this.defaultBoundingBox};
        if ((type == BoundingBoxType.COLLISION || type == BoundingBoxType.RAYTRACE || type == BoundingBoxType.RENDER) && (te.isOpened() || te.isMoving())) {
            aabbs = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, -0.5, 0.5, 4.0, 1.0), new AxisAlignedBB(3.5, 0.0, -0.5, 4.0, 4.0, 1.0), new AxisAlignedBB(0.0, 4.0, 0.8125, 4.0, 5.0, 1.0)};
        }
        return aabbs;
    }

    public int blockRange() {
        return 5;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new BigDoorTileEntity();
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        BigDoorTileEntity te;
        if (!player.field_71075_bZ.field_75098_d && (te = (BigDoorTileEntity)((Object)TileEntityUtils.getTileEntity(BigDoorTileEntity.class, (IBlockAccess)world, (BlockPos)pos))) != null) {
            BigDoor.func_180635_a((World)world, (BlockPos)pos, (ItemStack)te.getDroppedItemStack());
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Lists.newArrayList();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return true;
    }

    public static class BigDoorIconProvider
    implements IIconProvider {
        Icon itemIcon;
        Icon doorIcon;

        public BigDoorIconProvider(Type type) {
            this.itemIcon = Icon.from((String)("malisisdoors:items/" + type.name + "_item"));
            this.doorIcon = Icon.from((String)("malisisdoors:blocks/" + type.name));
        }

        public Icon getIcon() {
            return this.itemIcon;
        }

        public Icon getDoorIcon() {
            return this.doorIcon;
        }

        public static BigDoorIconProvider get(Type type) {
            return new BigDoorIconProvider(type);
        }
    }

    public static enum Type {
        CARRIAGE("carriage_door", Items.field_179570_aq),
        MEDIEVAL("medieval_door", Items.field_179569_ar);

        public String name;
        public Item door;

        private Type(String name, Item door) {
            this.name = name;
            this.door = door;
        }
    }
}

