/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.block;

import javax.vecmath.Matrix4f;
import net.malisis.core.MalisisCore;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.block.component.BooleanComponent;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.block.component.ItemTransformComponent;
import net.malisis.core.renderer.component.AnimatedModelComponent;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.Timer;
import net.malisis.core.util.TransformBuilder;
import net.malisis.core.util.chunkcollision.IChunkCollidable;
import net.malisis.doors.MalisisDoors;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ModelDoor
extends MalisisBlock
implements IChunkCollidable {
    private static BooleanComponent OPENED = new BooleanComponent("opened", false, 2);
    private AxisAlignedBB aabb = AABBUtils.identity();
    private AnimatedModelComponent amc = null;
    private ItemTransformComponent transformComp = new ItemTransformComponent();

    public ModelDoor() {
        super(Material.field_151573_f);
        this.func_149711_c(4.0f);
        this.func_149647_a(MalisisDoors.tab);
        this.setName("malisisdoors:hitechdoor");
        this.setTexture("malisisdoors:blocks/hitechdoor");
        this.aabb = new AxisAlignedBB(-1.0, 0.0, 0.375, 2.0, 2.0, 0.625);
        this.addComponent((IComponent)OPENED);
        this.addComponent((IComponent)new DirectionalComponent());
        if (MalisisCore.isClient()) {
            this.amc = new AnimatedModelComponent("malisisdoors:models/hitechdoor.obj");
            this.amc.onFirstRender(this::stateCheck);
            this.addComponent((IComponent)this.amc);
            this.setTransform();
            this.addComponent((IComponent)this.transformComp);
        }
    }

    private void setTransform() {
        Matrix4f gui = new TransformBuilder().translate(0.0f, -0.15f, 0.0f).rotate(30.0f, 45.0f, 0.0f).scale(0.34f).get();
        Matrix4f firstPerson = new TransformBuilder().rotate(0.0f, 135.0f, 0.0f).scale(0.2f).get();
        Matrix4f thirdPerson = new TransformBuilder().translate(0.0f, 0.155f, -0.1f).rotateAfter(75.0f, 100.0f, 0.0f).scale(0.25f).get();
        Matrix4f fixed = new TransformBuilder().translate(0.0f, -0.2f, 0.0f).scale(0.4f).get();
        Matrix4f ground = new TransformBuilder().translate(0.0f, 0.3f, 0.0f).scale(0.2f).get();
        this.transformComp.thirdPerson(thirdPerson, thirdPerson).firstPerson(firstPerson, firstPerson).fixed(fixed).gui(gui).ground(ground);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        boolean opened = OPENED.invert(world, pos);
        if (world.field_72995_K) {
            this.amc.link(pos, opened ? "close" : "open", opened ? "open" : "close");
        }
        return true;
    }

    public AxisAlignedBB getBoundingBox(IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        if (OPENED.get(state) && type == BoundingBoxType.COLLISION) {
            return null;
        }
        return this.aabb;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int blockRange() {
        return 2;
    }

    public void stateCheck(IBlockAccess world, BlockPos pos, IBlockState state, AnimatedModelComponent amc) {
        if (OPENED.get(state) && !amc.isAnimating(pos, "open")) {
            amc.start(pos, "open", new Timer(Integer.MIN_VALUE));
        }
    }
}

