/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.network;

import io.netty.buffer.ByteBuf;
import net.malisis.core.network.IMalisisMessageHandler;
import net.malisis.core.network.MalisisMessage;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.block.Door;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

@MalisisMessage
public class DigicodeMessage
implements IMalisisMessageHandler<Packet, IMessage> {
    public DigicodeMessage() {
        MalisisDoors.network.registerMessage((IMessageHandler)this, Packet.class, Side.SERVER);
    }

    public void process(Packet message, MessageContext ctx) {
        World world = ctx.getServerHandler().field_147369_b.field_70170_p;
        DoorTileEntity te = Door.getDoor((IBlockAccess)world, message.pos);
        if (te == null) {
            return;
        }
        te.openOrCloseDoor();
        if (te.getDescriptor().getAutoCloseTime() > 0 && !te.isOpened()) {
            world.func_180497_b(message.pos, world.func_180495_p(message.pos).func_177230_c(), te.getDescriptor().getAutoCloseTime() + te.getDescriptor().getOpeningTime(), 0);
        }
    }

    public static void send(DoorTileEntity te) {
        MalisisDoors.network.sendToServer((IMessage)new Packet(te));
    }

    public static class Packet
    implements IMessage {
        private BlockPos pos;

        public Packet(DoorTileEntity te) {
            this.pos = te.func_174877_v();
        }

        public Packet() {
        }

        public void fromBytes(ByteBuf buf) {
            this.pos = BlockPos.func_177969_a((long)buf.readLong());
        }

        public void toBytes(ByteBuf buf) {
            buf.writeLong(this.pos.func_177986_g());
        }
    }
}

