/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.renderer;

import javax.vecmath.Matrix4f;
import net.malisis.core.block.IComponent;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.AnimationRenderer;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.icon.VanillaIcon;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.util.TransformBuilder;
import net.malisis.core.util.multiblock.MultiBlock;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.block.RustyHatch;
import net.malisis.doors.tileentity.RustyHatchTileEntity;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class RustyHatchRenderer
extends MalisisRenderer<RustyHatchTileEntity> {
    public static RustyHatchRenderer instance;
    private ResourceLocation rl;
    private MalisisModel model;
    private Shape frame;
    private Shape hatch;
    private Shape handle;
    private Shape ladder;
    private RenderParameters rp = new RenderParameters();
    private AnimationRenderer ar = new AnimationRenderer();
    private RustyHatchTileEntity tileEntity;
    private RustyHatch.RustyHatchIconProvider iconProvider;
    private boolean topBlock;
    private EnumFacing direction;
    private Matrix4f gui = new TransformBuilder().translate(-0.55f, 0.55f, 0.15f).scale(0.75f).rotate(90.0f, 0.0f, 0.0f).get();
    private Matrix4f thirdPersone = new TransformBuilder().translate(0.0f, 0.15f, -0.25f).rotate(0.0f, -45.0f, 0.0f).scale(0.25f).get();

    public RustyHatchRenderer() {
        this.registerFor(RustyHatchTileEntity.class);
        instance = this;
    }

    protected void initialize() {
        this.rl = new ResourceLocation("malisisdoors", "models/rustyhatch.obj");
        this.model = new MalisisModel(this.rl);
        this.frame = this.model.getShape("frame");
        this.hatch = this.model.getShape("door");
        this.handle = this.model.getShape("handle");
        this.ladder = this.model.getShape("ladder");
        this.rp = new RenderParameters();
        this.rp.useBlockBounds.set((Object)false);
        this.rp.calculateBrightness.set((Object)false);
        this.iconProvider = (RustyHatch.RustyHatchIconProvider)IComponent.getComponent(RustyHatch.RustyHatchIconProvider.class, (Object)((Object)MalisisDoors.Blocks.rustyHatch));
    }

    private void setup(Shape s) {
        if (this.topBlock && s != this.ladder) {
            s.translate(0.0f, 0.875f, 0.0f);
        }
        if (this.direction == EnumFacing.SOUTH) {
            s.rotate(-90.0f, 0.0f, 1.0f, 0.0f);
        } else if (this.direction == EnumFacing.NORTH) {
            s.rotate(90.0f, 0.0f, 1.0f, 0.0f);
        } else if (this.direction == EnumFacing.WEST) {
            s.rotate(180.0f, 0.0f, 1.0f, 0.0f);
        }
    }

    public void render() {
        if (this.renderType == RenderType.ITEM) {
            this.renderItem();
            return;
        }
        this.tileEntity = RustyHatch.getRustyHatch(this.world, this.pos);
        if (this.tileEntity == null) {
            return;
        }
        this.direction = this.tileEntity.getDirection();
        this.rp.brightness.set((Object)this.blockState.func_185889_a(this.world, this.pos));
        this.topBlock = this.tileEntity.isTop();
        if (this.renderType == RenderType.BLOCK) {
            this.getBlockDamage = true;
            this.renderBlock();
        } else if (this.renderType == RenderType.TILE_ENTITY) {
            this.renderTileEntity();
        }
    }

    private void renderBlock() {
        if (!MultiBlock.isOrigin((IBlockAccess)this.world, (BlockPos)this.pos)) {
            if (!this.tileEntity.shouldLadder(this.pos)) {
                return;
            }
            if (this.ladder == null) {
                return;
            }
            this.ladder.resetState();
            this.setup(this.ladder);
            this.ladder.translate(-1.0f, this.topBlock ? 0.0f : 0.0f, 0.0f);
            this.rp.icon.set((Object)this.iconProvider.getHandleIcon());
            this.drawShape(this.ladder, this.rp);
        } else {
            if (this.frame == null) {
                return;
            }
            this.frame.resetState();
            this.setup(this.frame);
            this.rp.icon.set((Object)new VanillaIcon(Blocks.field_150460_al));
            this.drawShape(this.frame, this.rp);
        }
    }

    private void renderTileEntity() {
        if (this.hatch == null || this.handle == null) {
            return;
        }
        this.hatch.resetState();
        this.handle.resetState();
        this.setup(this.hatch);
        this.setup(this.handle);
        this.ar.setStartTime(this.tileEntity.getTimer().getStart());
        if (this.tileEntity.getMovement() != null) {
            Animation<?>[] anims = this.tileEntity.getMovement().getAnimations(this.tileEntity, this.model, this.rp);
            this.ar.animate(anims);
        }
        this.next(9);
        this.rp.icon.set((Object)this.iconProvider.getHatchIcon());
        this.drawShape(this.hatch, this.rp);
        this.rp.icon.set((Object)this.iconProvider.getHandleIcon());
        this.drawShape(this.handle, this.rp);
    }

    public Matrix4f getTransform(Item item, ItemCameraTransforms.TransformType tranformType) {
        Matrix4f firstPersonLeft = new TransformBuilder().translate(0.0f, 0.0f, -0.25f).rotate(0.0f, 135.0f, 0.0f).scale(0.25f).get();
        Matrix4f thirdPersonLeft = new TransformBuilder().translate(-0.2f, 0.25f, 0.0f).rotate(0.0f, 135.0f, 0.0f).scale(0.25f).get();
        switch (tranformType) {
            case GUI: {
                return this.gui;
            }
            case FIRST_PERSON_LEFT_HAND: {
                return firstPersonLeft;
            }
            case THIRD_PERSON_LEFT_HAND: {
                return thirdPersonLeft;
            }
        }
        return this.thirdPersone;
    }

    private void renderItem() {
        Shape shape = this.item == MalisisDoors.Items.rustyHandle ? this.handle : this.ladder;
        shape.resetState();
        shape.scale(1.5f);
        this.rp.icon.set((Object)this.iconProvider.getHandleIcon());
        this.drawShape(shape, this.rp);
    }
}

