/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.tileentity;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.block.component.PowerComponent;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.core.util.syncer.Syncable;
import net.malisis.doors.DoorState;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

@Syncable(value="TileEntity")
public class GarageDoorTileEntity
extends DoorTileEntity {
    public static final int maxOpenTime = 10;

    @Override
    public EnumFacing getDirection() {
        return DirectionalComponent.getDirection((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c);
    }

    @Override
    public IBlockState getBlockState() {
        return null;
    }

    public boolean isTop() {
        return this.isTop(this.field_174879_c);
    }

    public boolean isTop(BlockPos pos) {
        return this.getTopDoor() == this;
    }

    @Override
    public int getOpeningTime() {
        return this.getTopDoor().getDoors().size() * 10;
    }

    public GarageDoorTileEntity getTopDoor() {
        GarageDoorTileEntity te = this.getDoor(EnumFacing.UP);
        return te != null ? te.getTopDoor() : this;
    }

    @Override
    public boolean isPowered() {
        return PowerComponent.isPowered((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c);
    }

    public GarageDoorTileEntity getDoor(EnumFacing dir) {
        GarageDoorTileEntity te = (GarageDoorTileEntity)((Object)TileEntityUtils.getTileEntity(GarageDoorTileEntity.class, (IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(dir)));
        if (te == null || te.getDirection() != this.getDirection()) {
            return null;
        }
        if (dir.func_176740_k() != EnumFacing.Axis.Y) {
            return te;
        }
        return te.isPowered() == te.isPowered() && te.getState() == this.getState() ? te : null;
    }

    public Set<GarageDoorTileEntity> getDoors() {
        HashSet childDoors = Sets.newHashSet();
        for (GarageDoorTileEntity te = this; te != null; te = te.getDoor(EnumFacing.DOWN)) {
            childDoors.add(te);
        }
        return childDoors;
    }

    @Override
    public void setPowered(boolean powered) {
        GarageDoorTileEntity te2;
        if (!this.isTop()) {
            this.getTopDoor().setPowered(powered);
            return;
        }
        boolean isPowered = PowerComponent.isPowered((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c);
        if (isPowered == powered && !this.isMoving()) {
            return;
        }
        if (this.state == DoorState.OPENING && powered || this.state == DoorState.CLOSING && !powered) {
            return;
        }
        DoorState newState = powered ? DoorState.OPENING : DoorState.CLOSING;
        for (GarageDoorTileEntity te2 : this.getDoors()) {
            te2.setDoorState(newState);
            this.field_145850_b.func_175656_a(te2.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)PowerComponent.getProperty((Block)this.func_145838_q()), (Comparable)Boolean.valueOf(powered)));
        }
        EnumFacing dir = this.getDirection().func_176746_e();
        te2 = this.getDoor(dir);
        if (te2 != null) {
            te2.setPowered(powered);
        }
        if ((te2 = this.getDoor(dir.func_176734_d())) != null) {
            te2.setPowered(powered);
        }
    }

    @Override
    public void playSound() {
    }

    @Override
    public void func_73660_a() {
        if (this.state == DoorState.CLOSED || this.state == DoorState.OPENED) {
            return;
        }
        if (this.timer.elapsedTick() > (long)this.getOpeningTime()) {
            this.setDoorState(this.state == DoorState.CLOSING ? DoorState.CLOSED : DoorState.OPENED);
        }
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        Set<GarageDoorTileEntity> childDoors = this.getDoors();
        return AABBUtils.identity((BlockPos)this.field_174879_c).func_72314_b((double)childDoors.size(), (double)childDoors.size(), (double)childDoors.size());
    }
}

