/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block.component;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.malisis.core.MalisisCore;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IBlockComponent;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.renderer.component.SlopeShapeComponent;
import net.malisis.core.util.AABBUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SlopeComponent
implements IBlockComponent {
    public static PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");

    public PropertyBool getProperty() {
        return DOWN;
    }

    @Override
    public IBlockState setDefaultState(Block block, IBlockState state) {
        return state.func_177226_a((IProperty)this.getProperty(), (Comparable)Boolean.valueOf(false));
    }

    @Override
    public List<IComponent> getDependencies() {
        ArrayList deps = Lists.newArrayList((Object[])new IComponent[]{new DirectionalComponent()});
        if (MalisisCore.isClient()) {
            deps.add(new SlopeShapeComponent());
        }
        return deps;
    }

    @Override
    public IBlockState onBlockPlaced(Block block, World world, BlockPos pos, IBlockState state, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        boolean down = facing == EnumFacing.DOWN || facing != EnumFacing.UP && hitY > 0.5f;
        return state.func_177226_a((IProperty)this.getProperty(), (Comparable)Boolean.valueOf(down));
    }

    @Override
    public AxisAlignedBB[] getBoundingBoxes(Block block, IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        boolean down = SlopeComponent.isDown(state);
        float[][] fx = new float[][]{{0.0f, 1.0f}, {0.0f, 1.0f}};
        float[][] fy = new float[][]{{0.0f, 1.0f}, {0.0f, 1.0f}};
        float[][] fz = new float[][]{{0.0f, 1.0f}, {0.0f, 0.0f}};
        if (down) {
            fz = new float[][]{{0.0f, 0.125f}, {0.0f, 1.125f}};
        }
        return AABBUtils.slice(8, fx, fy, fz, true);
    }

    @Override
    public int getMetaFromState(Block block, IBlockState state) {
        return SlopeComponent.isDown(state) ? 8 : 0;
    }

    @Override
    public IBlockState getStateFromMeta(Block block, IBlockState state, int meta) {
        return state.func_177226_a((IProperty)this.getProperty(), (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    @Override
    public Boolean isOpaqueCube(Block block, IBlockState state) {
        return false;
    }

    @Override
    public Boolean isFullBlock(Block block, IBlockState state) {
        return false;
    }

    @Override
    public Boolean isFullCube(Block block, IBlockState state) {
        return false;
    }

    public static boolean isDown(IBlockAccess world, BlockPos pos) {
        return world != null && pos != null ? SlopeComponent.isDown(world.func_180495_p(pos)) : false;
    }

    public static boolean isDown(IBlockState state) {
        SlopeComponent sc = IComponent.getComponent(SlopeComponent.class, state.func_177230_c());
        if (sc == null) {
            return false;
        }
        PropertyBool property = sc.getProperty();
        if (property == null || !state.func_177228_b().containsKey((Object)property)) {
            return false;
        }
        return (Boolean)state.func_177229_b((IProperty)property);
    }
}

