/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.control;

import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.control.IControlComponent;
import net.malisis.core.renderer.icon.provider.GuiIconProvider;
import net.malisis.core.util.MouseButton;

public class UIMoveHandle
extends UIComponent<UIMoveHandle>
implements IControlComponent {
    private Type type;

    public UIMoveHandle(MalisisGui gui, UIComponent<?> parent, Type type) {
        super(gui);
        this.type = type != null ? type : Type.BOTH;
        int x = 1;
        int y = 1;
        if (parent instanceof UIContainer) {
            x -= ((UIContainer)parent).getHorizontalPadding();
            y -= ((UIContainer)parent).getVerticalPadding();
        }
        this.setPosition(x, y);
        this.setSize(5, 5);
        this.setZIndex(10);
        this.register(this);
        parent.addControlComponent(this);
        this.iconProvider = new GuiIconProvider(gui.getGuiTexture().getIcon(268, 15, 15, 15));
    }

    public UIMoveHandle(MalisisGui gui, UIComponent<?> parent) {
        this(gui, parent, Type.BOTH);
    }

    @Override
    public boolean onDrag(int lastX, int lastY, int x, int y, MouseButton button) {
        if (button != MouseButton.LEFT) {
            return super.onDrag(lastX, lastY, x, y, button);
        }
        UIComponent<?> parentCont = this.getParent().getParent();
        if (parentCont == null) {
            return super.onDrag(lastX, lastY, x, y, button);
        }
        int px = this.parent.getX();
        if (this.type == Type.BOTH || this.type == Type.HORIZONTAL) {
            px = parentCont.relativeX(x);
        }
        int py = this.parent.getY();
        if (this.type == Type.BOTH || this.type == Type.VERTICAL) {
            py = parentCont.relativeY(y);
        }
        if (px < 0) {
            px = 0;
        }
        if (py < 0) {
            py = 0;
        }
        this.getParent().setPosition(px, py, Anchor.NONE);
        return true;
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        renderer.drawShape(this.shape, this.rp);
    }

    public static enum Type {
        BOTH,
        HORIZONTAL,
        VERTICAL;

    }
}

