/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.registry;

import java.util.stream.StreamSupport;
import net.malisis.core.MalisisCore;
import net.malisis.core.block.IComponentProvider;
import net.malisis.core.block.IRegisterComponent;
import net.malisis.core.registry.ClientRegistry;
import net.malisis.core.registry.MalisisRegistry;
import net.malisis.core.registry.ModEventRegistry;
import net.malisis.core.registry.RenderBlockRegistry;
import net.malisis.core.registry.SetBlockCallbackRegistry;
import net.malisis.core.util.callback.CallbackResult;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.event.FMLEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Registries {
    @SideOnly(value=Side.CLIENT)
    static ClientRegistry clientRegistry;
    static ModEventRegistry modEventRegistry;
    static RenderBlockRegistry renderBlockRegistry;
    static SetBlockCallbackRegistry preSetBlockRegistry;
    static SetBlockCallbackRegistry postSetBlockRegistry;

    public static void processFMLStateEvent(FMLStateEvent event) {
        modEventRegistry.processCallbacks((FMLEvent)event);
    }

    @SideOnly(value=Side.CLIENT)
    public static CallbackResult<Boolean> processRenderBlockCallbacks(VertexBuffer buffer, IBlockAccess world, BlockPos pos, IBlockState state) {
        return renderBlockRegistry.processCallbacks(buffer, world, pos, state);
    }

    public static CallbackResult<Void> processPreSetBlock(Chunk chunk, BlockPos pos, IBlockState oldState, IBlockState newState) {
        CallbackResult<Void> ret = preSetBlockRegistry.processCallbacks(chunk, pos, oldState, newState);
        return ret;
    }

    public static void processPostSetBlock(Chunk chunk, BlockPos pos, IBlockState oldState, IBlockState newState) {
        postSetBlockRegistry.processCallbacks(chunk, pos, oldState, newState);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean renderItem(ItemStack itemStack) {
        return clientRegistry.renderItem(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite getParticleIcon(IBlockState state) {
        return ClientRegistry.getParticleIcon(state);
    }

    static {
        modEventRegistry = new ModEventRegistry();
        renderBlockRegistry = new RenderBlockRegistry();
        preSetBlockRegistry = new SetBlockCallbackRegistry();
        postSetBlockRegistry = new SetBlockCallbackRegistry();
        MalisisRegistry.onInit(event -> StreamSupport.stream(Block.field_149771_c.spliterator(), false).filter(IComponentProvider.class::isInstance).map(IComponentProvider.class::cast).forEach(p -> p.getComponents().stream().filter(IRegisterComponent.class::isInstance).map(IRegisterComponent.class::cast).forEach(comp -> comp.register((IComponentProvider)p))));
        if (MalisisCore.isClient()) {
            clientRegistry = new ClientRegistry();
        }
    }
}

