/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.component;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.malisis.core.block.IBoundingBox;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.IComponentProvider;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.renderer.AnimatedRenderer;
import net.malisis.core.renderer.IAnimatedRenderable;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.component.ModelComponent;
import net.malisis.core.util.Timer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class AnimatedModelComponent
extends ModelComponent {
    private Set<String> staticShapes = Sets.newHashSet();
    private Set<String> animatedShapes = Sets.newHashSet();
    private IStateCheck stateCheck = null;
    RenderParameters rp = new RenderParameters();

    public AnimatedModelComponent(String modelName) {
        super(modelName);
        this.rp.rotateIcon.set(false);
        this.autoDetectAnimatedGroups();
    }

    private void autoDetectAnimatedGroups() {
        this.animatedShapes = this.model.getAnimatedShapes();
        this.staticShapes = this.model.getShapeNames().stream().filter(s -> !this.animatedShapes.contains(s)).collect(Collectors.toSet());
    }

    private Optional<IAnimatedRenderable> get(BlockPos pos) {
        return AnimatedRenderer.getRenderable(pos);
    }

    private Timer addTimer(BlockPos pos, String animation, Timer timer) {
        return this.get(pos).map(amc -> amc.addTimer(animation, timer)).orElse(null);
    }

    private Timer removeTimer(BlockPos pos, String animation) {
        return this.get(pos).map(amc -> amc.removeTimer(animation)).orElse(null);
    }

    private Timer getTimer(BlockPos pos, String animation) {
        return this.get(pos).map(amc -> amc.getTimer(animation)).orElse(null);
    }

    public void onFirstRender(IStateCheck stateCheck) {
        this.stateCheck = stateCheck;
    }

    public void checkState(IBlockAccess world, BlockPos pos, IBlockState state) {
        if (this.stateCheck != null) {
            this.stateCheck.accept(world, pos, state, this);
        }
    }

    public Timer start(BlockPos pos, String animation) {
        return this.start(pos, animation, new Timer());
    }

    public Timer start(BlockPos pos, String animation, Timer timer) {
        if (!this.isAnimating(pos, animation)) {
            this.addTimer(pos, animation, timer);
        }
        return this.getTimer(pos, animation);
    }

    public Timer forceStart(BlockPos pos, String animation) {
        return this.forceStart(pos, animation, new Timer());
    }

    public Timer forceStart(BlockPos pos, String animation, Timer timer) {
        this.stop(pos, animation);
        return this.addTimer(pos, animation, timer);
    }

    public Timer stop(BlockPos pos, String animation) {
        return this.removeTimer(pos, animation);
    }

    public Timer link(BlockPos pos, String stop, String start) {
        Timer t = this.stop(pos, stop);
        if (t == null) {
            return this.start(pos, start);
        }
        Animation anim = (Animation)Iterables.getFirst(this.model.getAnimation(stop), null);
        if (anim == null) {
            return this.start(pos, start);
        }
        long duration = anim.getTransformation().getDuration();
        if (duration <= t.elapsedTime()) {
            return this.start(pos, start);
        }
        t.setRelativeStart(t.elapsedTime() - duration);
        this.addTimer(pos, start, t);
        return t;
    }

    public boolean isAnimating(BlockPos pos, String animation) {
        return this.getTimer(pos, animation) != null;
    }

    private void onRender(IBlockAccess world, BlockPos pos, IBlockState state) {
        AnimatedRenderer.registerRenderable(world, pos, this);
        this.checkState(world, pos, state);
    }

    @Override
    public void render(Block block, MalisisRenderer<TileEntity> renderer) {
        if (renderer.getRenderType() == RenderType.BLOCK && this.animatedShapes.size() != 0) {
            this.onRender(renderer.getWorldAccess(), renderer.getPos(), renderer.getBlockState());
        }
        RenderParameters rp = new RenderParameters();
        rp.rotateIcon.set(false);
        if (this.staticShapes.isEmpty() && this.animatedShapes.isEmpty()) {
            super.render(block, renderer);
            return;
        }
        this.model.resetState();
        if (renderer.getRenderType() == RenderType.BLOCK) {
            this.model.rotate(DirectionalComponent.getDirection(renderer.getBlockState()));
        }
        this.staticShapes.forEach(name -> this.model.render((MalisisRenderer<?>)renderer, (String)name));
        if (renderer.getRenderType() == RenderType.ITEM) {
            this.animatedShapes.forEach(name -> this.model.render(renderer, (String)name, rp));
        }
    }

    public AMC createRenderable(IBlockAccess world, BlockPos pos) {
        return new AMC(world, pos);
    }

    public static AnimatedModelComponent get(IComponentProvider block) {
        return IComponent.getComponent(AnimatedModelComponent.class, block);
    }

    public class AMC
    implements IAnimatedRenderable {
        private IBlockAccess world;
        private BlockPos pos;
        private Map<String, Timer> timers = Maps.newHashMap();

        public AMC(IBlockAccess world, BlockPos pos) {
            this.world = world;
            this.pos = pos;
        }

        @Override
        public BlockPos getPos() {
            return this.pos;
        }

        @Override
        public IBlockAccess getWorld() {
            return this.world;
        }

        public AnimatedModelComponent getComponent() {
            return AnimatedModelComponent.this;
        }

        @Override
        public Timer addTimer(String animation, Timer timer) {
            return this.timers.put(animation, (Timer)Preconditions.checkNotNull((Object)timer));
        }

        @Override
        public Timer removeTimer(String animation) {
            return this.timers.remove(animation);
        }

        @Override
        public Timer getTimer(String animation) {
            return this.timers.get(animation);
        }

        public Map<String, Timer> getTimers() {
            return ImmutableMap.copyOf(this.timers);
        }

        @Override
        public boolean inFrustrum(ICamera camera) {
            return camera.func_78546_a(IBoundingBox.getRenderingBounds(this.world, this.pos));
        }

        @Override
        public void renderAnimated(Block block, AnimatedRenderer renderer) {
            if (AnimatedModelComponent.this.animatedShapes.size() == 0) {
                return;
            }
            AnimatedModelComponent.this.model.resetState();
            if (renderer.getRenderType() == RenderType.ANIMATED) {
                AnimatedModelComponent.this.model.rotate(DirectionalComponent.getDirection(renderer.getBlockState()));
                Map<String, Timer> timers = this.getTimers();
                for (Map.Entry<String, Timer> entry : timers.entrySet()) {
                    if (!AnimatedModelComponent.this.model.animate(entry.getKey(), entry.getValue())) continue;
                    timers.remove(renderer.getPos(), entry.getKey());
                }
            }
            AnimatedModelComponent.this.animatedShapes.forEach(name -> AnimatedModelComponent.this.model.render(renderer, (String)name, AnimatedModelComponent.this.rp));
        }
    }

    public static interface IStateCheck {
        public void accept(IBlockAccess var1, BlockPos var2, IBlockState var3, AnimatedModelComponent var4);
    }
}

