/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.font;

import net.malisis.core.renderer.font.FontRenderOptions;
import net.malisis.core.renderer.font.Link;
import net.malisis.core.renderer.font.MalisisFont;
import net.minecraft.util.text.TextFormatting;

public class StringWalker {
    private MalisisFont font;
    private FontRenderOptions fro;
    private String str;
    private boolean litteral;
    private boolean skipChars = true;
    private boolean applyStyles;
    private boolean isText;
    private int prevColor;
    private boolean prevUnderline;
    private int index;
    private int endIndex;
    private char c;
    private TextFormatting format;
    private Link link;
    private float width;

    public StringWalker(String str, MalisisFont font, FontRenderOptions fro) {
        this.str = str;
        this.font = font;
        this.fro = fro;
        this.index = 0;
        this.endIndex = str.length();
        this.litteral = fro != null && fro.disableECF;
    }

    public void setLitteral(boolean litteral) {
        this.litteral = litteral;
    }

    public void skipChars(boolean skip) {
        this.skipChars = skip;
    }

    public void applyStyles(boolean apply) {
        this.applyStyles = apply;
    }

    public boolean isApplyStyles() {
        return this.applyStyles;
    }

    public int getIndex() {
        return this.index;
    }

    public char getChar() {
        return this.c;
    }

    public TextFormatting getFormatting() {
        return this.format;
    }

    public boolean isFormatted() {
        return this.format != null;
    }

    public Link getLink() {
        return this.link;
    }

    public boolean isLink() {
        return this.link != null;
    }

    public float getWidth() {
        return this.width;
    }

    public void startIndex(int index) {
        this.index = index;
    }

    public void endIndex(int index) {
        if (index == 0) {
            index = this.str.length();
        }
        this.endIndex = index;
    }

    private void setLinkStyle(FontRenderOptions fro) {
        if (fro == null || this.litteral || !this.applyStyles) {
            return;
        }
        this.prevColor = fro.color;
        this.prevUnderline = fro.underline;
        fro.color = 0x6666FF;
        fro.underline = true;
    }

    private void resetLinkStyle(FontRenderOptions fro) {
        if (fro == null || this.litteral || !this.applyStyles) {
            return;
        }
        fro.color = this.prevColor;
        fro.underline = this.prevUnderline;
    }

    private void checkEcf() {
        this.format = FontRenderOptions.getFormatting(this.str, this.index);
        if (this.format == null) {
            this.format = FontRenderOptions.getFormatting(this.str, this.index - 1);
        }
        if (this.format == null) {
            return;
        }
        if (this.applyStyles && this.fro != null && !this.isLink()) {
            this.fro.apply(this.format);
        }
        if (this.skipChars && !this.litteral) {
            this.index += 2;
            this.checkEcf();
        }
    }

    public void checkLink() {
        if (this.link != null) {
            this.isText = this.link.isText(this.getIndex());
            if (this.str.charAt(this.index) == ']') {
                this.resetLinkStyle(this.fro);
                if (this.skipChars && !this.litteral) {
                    ++this.index;
                }
            }
        } else {
            this.link = FontRenderOptions.getLink(this.str, this.index);
            if (this.isLink()) {
                if (this.skipChars && !this.litteral) {
                    this.index += this.link.indexAdvance();
                }
                this.setLinkStyle(this.fro);
            }
        }
    }

    public int walkTo(float x) {
        float width = 0.0f;
        while (this.walk()) {
            if (!((width += this.getWidth()) > x)) continue;
            return this.getIndex() - 1;
        }
        return this.getIndex();
    }

    public boolean walk() {
        if (this.index >= this.endIndex) {
            return false;
        }
        this.checkEcf();
        if (this.index >= this.endIndex) {
            return false;
        }
        this.c = this.str.charAt(this.index);
        this.width = this.font.getCharWidth(this.c, this.fro);
        if (this.fro != null && this.fro.bold) {
            this.width += this.fro.fontScale;
        }
        if (!(this.litteral || this.skipChars || this.format == null && (this.link == null || this.isText))) {
            this.width = 0.0f;
        }
        ++this.index;
        return true;
    }
}

