/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.icon;

import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.malisis.core.renderer.icon.VanillaIcon;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import org.apache.commons.lang3.StringUtils;

public class Icon
extends TextureAtlasSprite {
    private static final Map<String, Icon> registeredIcons = Maps.newHashMap();
    public static Icon missing = new VanillaIcon.MissingIcon();
    public static int BLOCK_TEXTURE_WIDTH = -1;
    public static int BLOCK_TEXTURE_HEIGHT = -1;
    protected int sheetWidth;
    protected int sheetHeight;
    protected boolean flippedU = false;
    protected boolean flippedV = false;
    protected int rotation = 0;
    protected Set<Icon> dependants = new HashSet<Icon>();

    public Icon(String name, boolean register) {
        super(name);
        this.field_110980_m = 1.0f;
        this.field_110978_o = 1.0f;
        if (register && !StringUtils.isEmpty((CharSequence)name) && !registeredIcons.containsKey(name)) {
            registeredIcons.put(name, this);
        }
    }

    public Icon(String name) {
        this(name, true);
    }

    public Icon() {
        this("", false);
    }

    public Icon(Icon baseIcon) {
        this(baseIcon.func_94215_i(), false);
        baseIcon.addDependant(this);
    }

    public Icon(String name, float u, float v, float U, float V) {
        this(name, true);
        this.field_110979_l = u;
        this.field_110977_n = v;
        this.field_110980_m = U;
        this.field_110978_o = V;
    }

    public Icon(TextureAtlasSprite icon) {
        this(icon.func_94215_i(), false);
        this.func_94217_a(icon);
    }

    public void addDependant(Icon icon) {
        this.dependants.add(icon);
    }

    public void setSize(int width, int height) {
        this.field_130223_c = width;
        this.field_130224_d = height;
    }

    public void setUVs(float u, float v, float U, float V) {
        this.field_110979_l = u;
        this.field_110977_n = v;
        this.field_110980_m = U;
        this.field_110978_o = V;
    }

    public float func_94209_e() {
        return this.flippedU ? this.field_110980_m : this.field_110979_l;
    }

    public float func_94212_f() {
        return this.flippedU ? this.field_110979_l : this.field_110980_m;
    }

    public float func_94206_g() {
        return this.flippedV ? this.field_110978_o : this.field_110977_n;
    }

    public float func_94210_h() {
        return this.flippedV ? this.field_110977_n : this.field_110978_o;
    }

    public Icon flip(boolean horizontal, boolean vertical) {
        this.flippedU = horizontal;
        this.flippedV = vertical;
        return this;
    }

    public boolean isFlippedU() {
        return this.flippedU;
    }

    public boolean isFlippedV() {
        return this.flippedV;
    }

    public boolean isRotated() {
        return this.rotation != 0;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public int getRotation() {
        return this.rotation;
    }

    protected void initIcon(Icon baseIcon, int width, int height, int x, int y, boolean rotated) {
        this.func_94217_a(baseIcon);
    }

    public Icon offset(int offsetX, int offsetY) {
        this.func_110971_a(this.sheetWidth, this.sheetHeight, this.func_130010_a() + offsetX, this.func_110967_i() + offsetY, this.isRotated());
        return this;
    }

    public Icon clip(int offsetX, int offsetY, int width, int height) {
        this.field_130223_c = width;
        this.field_130224_d = height;
        this.offset(offsetX, offsetY);
        return this;
    }

    public Icon clip(float offsetXFactor, float offsetYFactor, float widthFactor, float heightFactor) {
        int offsetX = Math.round((float)this.field_130223_c * offsetXFactor);
        int offsetY = Math.round((float)this.field_130224_d * offsetYFactor);
        this.field_130223_c = Math.round((float)this.field_130223_c * widthFactor);
        this.field_130224_d = Math.round((float)this.field_130224_d * heightFactor);
        this.offset(offsetX, offsetY);
        return this;
    }

    public void func_110971_a(int width, int height, int x, int y, boolean rotated) {
        if (width == 0 || height == 0) {
            width = BLOCK_TEXTURE_WIDTH;
            height = BLOCK_TEXTURE_HEIGHT;
        }
        this.sheetWidth = width;
        this.sheetHeight = height;
        super.func_110971_a(width, height, x, y, rotated);
        for (TextureAtlasSprite textureAtlasSprite : this.dependants) {
            if (textureAtlasSprite instanceof Icon) {
                ((Icon)textureAtlasSprite).initIcon(this, width, height, x, y, rotated);
                continue;
            }
            textureAtlasSprite.func_94217_a((TextureAtlasSprite)this);
        }
    }

    public void func_94217_a(TextureAtlasSprite base) {
        this.field_110975_c = base.func_130010_a();
        this.field_110974_d = base.func_110967_i();
        this.field_130223_c = base.func_94211_a();
        this.field_130224_d = base.func_94216_b();
        this.field_110979_l = base.func_94209_e();
        this.field_110980_m = base.func_94212_f();
        this.field_110977_n = base.func_94206_g();
        this.field_110978_o = base.func_94210_h();
        for (int i = 0; i < base.func_110970_k(); ++i) {
            this.field_110976_a.add(base.func_147965_a(i));
        }
        if (base instanceof Icon) {
            Icon mbase = (Icon)base;
            this.sheetWidth = mbase.sheetWidth;
            this.sheetHeight = mbase.sheetHeight;
            this.flippedU = mbase.flippedU;
            this.flippedV = mbase.flippedV;
        }
    }

    public Icon copy() {
        Icon icon = new Icon();
        icon.func_94217_a(this);
        return icon;
    }

    public static void registerIcons(TextureMap map) {
        registeredIcons.forEach((arg_0, arg_1) -> ((TextureMap)map).setTextureEntry(arg_0, arg_1));
    }

    public static Icon from(String name) {
        if (name.indexOf("minecraft:") == 0) {
            return new VanillaIcon(name);
        }
        if (registeredIcons.get(name) != null) {
            return registeredIcons.get(name);
        }
        return new Icon(name);
    }

    public static Icon from(Block block) {
        return Icon.from(block.func_176223_P());
    }

    public static Icon from(IBlockState state) {
        return new VanillaIcon(state);
    }

    public static Icon from(Item item) {
        return new VanillaIcon(item);
    }

    public static Icon getRegistered(String name) {
        return registeredIcons.get(name);
    }
}

