/*
 * Decompiled with CFR 0.152.
 */
package mo_swords;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import mo_swords.IMetablock;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class moSwordsHelper {
    protected static List<ItemStack> ids = new ArrayList<ItemStack>();
    protected static List<IRecipe> recipes = new ArrayList<IRecipe>();

    protected static void loadProperty(Class c) throws Exception {
        File f1 = new File(Minecraft.func_71410_x().field_71412_D, "config");
        f1.mkdir();
        File f2 = new File(f1, c.getSimpleName() + ".cfg");
        Object o = c.newInstance();
        if (!f2.exists()) {
            f2.createNewFile();
            Properties pro = new Properties();
            Field[] props = c.getDeclaredFields();
            String s = "MoSwords Config File\n";
            for (Field f : props) {
                Property a = f.getAnnotation(Property.class);
                if (a == null) continue;
                pro.setProperty(f.getName(), f.get(o) + "");
                s = s + f.getName() + " : " + a.info() + "\n";
            }
            FileOutputStream out = new FileOutputStream(f2);
            pro.store(out, s);
            out.close();
            return;
        }
        try {
            Field[] props;
            Properties pro = new Properties();
            FileInputStream in = new FileInputStream(f2);
            pro.load(in);
            in.close();
            for (Field f : props = c.getDeclaredFields()) {
                if (f.getAnnotation(Property.class) == null || moSwordsHelper.edit(o, pro.getProperty(f.getName()), f)) continue;
                f2.delete();
            }
        }
        catch (Exception e) {
            System.err.println("Cant read Property File for " + c.getSimpleName());
            f2.delete();
        }
    }

    protected static void registerItems(Object o) {
        Field[] fields;
        Class<?> c = o.getClass();
        for (Field f : fields = c.getFields()) {
            if (!f.getType().isAssignableFrom(Item.class)) continue;
            System.out.println(f);
            try {
                Item i = (Item)f.get(o);
                String unlocalisized = i.func_77658_a();
                if (unlocalisized.startsWith("item.")) {
                    unlocalisized = unlocalisized.replaceFirst("item.", "");
                }
                GameRegistry.registerItem((Item)i, (String)unlocalisized.toLowerCase());
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    protected static boolean edit(Object source, String value, Field object) {
        if (object.getType() == String.class) {
            try {
                object.set(source, value.replaceAll("\"", ""));
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Method m = null;
        try {
            Class<Object> ty = object.getType();
            if (ty == Byte.TYPE) {
                ty = Byte.class;
            }
            if (ty == Short.TYPE) {
                ty = Short.class;
            }
            if (ty == Integer.TYPE) {
                ty = Integer.class;
            }
            if (ty == Float.TYPE) {
                ty = Float.class;
            }
            if (ty == Double.TYPE) {
                ty = Double.class;
            }
            if (ty == Boolean.TYPE) {
                ty = Boolean.class;
            }
            if (ty == Character.TYPE) {
                ty = Character.class;
            }
            m = ty.getDeclaredMethod("valueOf", String.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (m != null) {
            try {
                object.set(source, m.invoke(object.get(source), value));
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    protected static void addSmelting(ItemStack input, ItemStack output, float experience) {
        ids.add(input);
        GameRegistry.addSmelting((ItemStack)input, (ItemStack)output, (float)experience);
    }

    protected static void registerRendering(Object mod) throws Exception {
        Field[] fields;
        for (Field f : fields = mod.getClass().getFields()) {
            Item item = null;
            String name = "";
            int maxmeta = 0;
            if (f.getType() == Item.class) {
                item = (Item)f.get(mod);
                if (item instanceof IMetablock) {
                    maxmeta = ((IMetablock)item).getMaxmeta();
                }
                if (item instanceof IItemColor) {
                    Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)item, new Item[]{item});
                }
            } else {
                if (f.getType() != Block.class) continue;
                Block block = (Block)f.get(mod);
                if (block instanceof IMetablock) {
                    maxmeta = ((IMetablock)block).getMaxmeta();
                }
                item = Item.func_150898_a((Block)block);
            }
            for (int i = 0; i <= maxmeta; ++i) {
                ItemStack it = new ItemStack(item, 1, i);
                name = it.func_77977_a().toLowerCase();
                name = item instanceof ItemBlock ? name.replaceFirst("tile.", "") : name.replaceFirst("item.", "");
                ResourceLocation res = new ResourceLocation("mo_swords", name);
                ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{res});
                ModelResourceLocation mres = new ModelResourceLocation(res, "inventory");
                System.out.println(String.format("Register %s in %s", it, res));
                Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(it.func_77973_b(), it.func_77952_i(), mres);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    protected static @interface Property {
        public String info();
    }
}

