/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.common.compression;

import aroma1997.backup.common.compression.CompressionHelper;
import aroma1997.backup.common.compression.ICompression;
import aroma1997.backup.common.info.BackupInfoUtil;
import aroma1997.backup.common.info.CreatingBackupInfo;
import aroma1997.backup.common.info.ExistingBackupInfo;
import aroma1997.backup.common.util.Environment;
import aroma1997.backup.common.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;

public class BackupHelper {
    private static final String INCREMENTAL_FILE = "incremental.aromabackup";
    private static final Set<String> blacklist = new HashSet<String>(Arrays.asList("incremental.aromabackup"));

    private BackupHelper() {
    }

    public static ExistingBackupInfo makeBackup(CreatingBackupInfo info, Map<File, String> files) throws IOException {
        return BackupHelper.makeBackup(info, files, Environment.getEnv().getCompressionRate());
    }

    public static ExistingBackupInfo makeBackup(CreatingBackupInfo info, Map<File, String> files, int compressionRate) throws IOException {
        File target = info.getBackupFile();
        File previous = info.getParentFile();
        ICompression compression = BackupHelper.getCompression(target);
        if (compression == null) {
            throw new IllegalArgumentException("No compression helper registered for the given target file:" + target.getName());
        }
        if (target.isFile() && target.exists()) {
            throw new IllegalStateException("File already exists.");
        }
        for (String s : blacklist) {
            files.remove(s);
        }
        File incremental = BackupHelper.createIncrementalFile(files);
        if (previous != null) {
            HashMap<File, String> discovered = new HashMap<File, String>();
            for (Map.Entry<File, String> e : files.entrySet()) {
                if (e.getKey().isFile()) {
                    discovered.put(e.getKey(), e.getValue());
                    continue;
                }
                CompressionHelper.discover(discovered, e.getKey(), e.getValue());
            }
            files = discovered;
            Map<String, String> prevFileToHash = BackupHelper.loadFileHashes(info.getParent());
            Iterator<Map.Entry<File, String>> iter = files.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<File, String> e = iter.next();
                String fileloc = CompressionHelper.appendFilename(e.getValue(), e.getKey().getName());
                if (!prevFileToHash.containsKey(fileloc)) continue;
                String currentHash = Util.getHash(e.getKey());
                String oldHash = prevFileToHash.get(fileloc);
                Environment.getEnv().logDebug("File: " + fileloc);
                Environment.getEnv().logDebug("Current: " + currentHash);
                Environment.getEnv().logDebug("Prev.  : " + oldHash);
                Environment.getEnv().logDebug("");
                if (!currentHash.equals(oldHash)) continue;
                iter.remove();
            }
        }
        target.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(target);
        compression.compress(fos, files.entrySet(), compressionRate);
        fos.flush();
        fos.close();
        info.createInfoFile();
        incremental.delete();
        return new ExistingBackupInfo(target);
    }

    public static void restoreBackup(ExistingBackupInfo info, File target) throws IOException {
        if (target.exists()) {
            throw new FileAlreadyExistsException("Cannot extract backup to already existing folder.");
        }
        File tmp = Environment.getEnv().getTmpDir("backupRestore");
        if (tmp.exists()) {
            tmp.delete();
        }
        tmp.mkdirs();
        BackupHelper.restoreFilesLimited(info, test -> true, tmp, () -> true, false);
        new File(tmp, INCREMENTAL_FILE).delete();
        Files.move(tmp.toPath(), target.toPath(), new CopyOption[0]);
        tmp.delete();
    }

    public static boolean restoreIndividualFile(ExistingBackupInfo info, File target, String name) throws FileNotFoundException, IOException {
        return BackupHelper.restoreIndividualFile(info, target, name, false);
    }

    private static boolean restoreIndividualFile(ExistingBackupInfo info, File target, String name, boolean keepIncremental) throws FileNotFoundException, IOException {
        File dir = Environment.getEnv().getTmpDir("restoreIndividual");
        if (dir.exists()) {
            Util.deleteFile(dir);
        }
        dir.mkdirs();
        File targetFile = new File(dir, name);
        BackupHelper.restoreFilesLimited(info, test -> name.equals(test), dir, () -> !targetFile.exists(), keepIncremental);
        if (!targetFile.exists()) {
            Util.deleteFile(dir);
            return false;
        }
        if (target.exists()) {
            Util.deleteFile(target);
        }
        Files.move(targetFile.toPath(), target.toPath(), new CopyOption[0]);
        Util.deleteFile(dir);
        return true;
    }

    public static void restoreFilesLimited(ExistingBackupInfo info, Predicate<String> shouldRestore, File target, BooleanSupplier shouldContinue) throws FileNotFoundException, IOException {
        BackupHelper.restoreFilesLimited(info, shouldRestore, target, shouldContinue, false);
    }

    private static void restoreFilesLimited(ExistingBackupInfo info, Predicate<String> shouldRestore, File target, BooleanSupplier shouldContinue, boolean keepIncremental) throws FileNotFoundException, IOException {
        HashSet<String> values = new HashSet<String>();
        do {
            File source;
            if (!BackupInfoUtil.isBackup(source = info.getBackupFile())) {
                throw new IOException("An invalid backup showed up in the backup hierarchy.");
            }
            ICompression compression = BackupHelper.getCompression(source);
            Environment.getEnv().log("Unpacking backup: " + source.getAbsolutePath());
            compression.decompress(new FileInputStream(source), test -> (values.isEmpty() || values.contains(test)) && shouldRestore.test((String)test) ? (new File(target, (String)test).exists() ? null : new File(target, (String)test)) : null);
            Environment.getEnv().log("Done.");
            if (!shouldContinue.getAsBoolean()) break;
            if (!values.isEmpty()) continue;
            Environment.getEnv().log("Loading backup restore info.");
            BackupHelper.getTargetFiles(target, values);
        } while ((info = info.getParent()) != null);
        Environment.getEnv().log("Done unpacking backups.");
        Environment.getEnv().log("Moving files to target dir.");
        if (!keepIncremental) {
            new File(target, INCREMENTAL_FILE).delete();
        }
    }

    private static void getTargetFiles(File targetDir, Set<String> ret) throws IOException {
        File process = new File(targetDir, INCREMENTAL_FILE);
        if (!process.isFile() || !process.exists()) {
            return;
        }
        BufferedReader br = new BufferedReader(new FileReader(process));
        while (br.ready()) {
            String line = br.readLine();
            if (line.contains("=")) {
                line = line.split("=")[0];
            }
            if (line.startsWith("#")) continue;
            ret.add(line);
        }
        br.close();
        process.delete();
    }

    private static File createIncrementalFile(Map<File, String> files) throws IOException {
        File targetFile = new File(Environment.getEnv().getTmpDir("incrementalTmp"), INCREMENTAL_FILE);
        if (targetFile.exists()) {
            targetFile.delete();
        }
        targetFile.getParentFile().mkdirs();
        PrintStream ps = new PrintStream(targetFile);
        for (Map.Entry<File, String> e : files.entrySet()) {
            BackupHelper.printFile(ps, e.getKey(), e.getValue());
        }
        ps.flush();
        ps.close();
        files.put(targetFile, "");
        return targetFile;
    }

    private static void printFile(PrintStream ps, File file, String target) throws FileNotFoundException {
        String newTarget;
        String string = newTarget = target.isEmpty() ? file.getName() : target + "/" + file.getName();
        if (file.isFile()) {
            ps.println(newTarget + "=" + Util.getHash(file));
        }
        if (file.isDirectory()) {
            for (File sub : file.listFiles()) {
                BackupHelper.printFile(ps, sub, newTarget);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> loadFileHashes(ExistingBackupInfo info) throws FileNotFoundException, IOException {
        File target = new File(Environment.getEnv().getTmpDir("incrementalTmp"), "incrementalLast.aromabackup");
        try {
            if (target.exists()) {
                target.delete();
            }
            if (!BackupHelper.restoreIndividualFile(info, target, INCREMENTAL_FILE, true)) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                return hashMap;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            try (BufferedReader br = new BufferedReader(new FileReader(target));){
                while (br.ready()) {
                    String line = br.readLine();
                    if (line.startsWith("#")) continue;
                    String[] split = line.split("=");
                    if (split.length == 1) {
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        return hashMap;
                    }
                    assert (split.length == 2);
                    map.put(split[0], split[1]);
                }
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        finally {
            target.delete();
        }
    }

    public static ICompression getCompression(File file) {
        if (file == null) {
            return null;
        }
        return CompressionHelper.getCompression(Util.getExtension(file.getName()).toLowerCase());
    }
}

