/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.common.info;

import aroma1997.backup.common.info.BackupInfo;
import aroma1997.backup.common.info.BackupInfoUtil;
import aroma1997.backup.common.util.IOHelper;
import aroma1997.backup.common.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class ExistingBackupInfo
extends BackupInfo {
    private final Date date;
    private final File parent;
    private final String world;

    public ExistingBackupInfo(File backup) throws IOException {
        super(backup, null);
        if (!backup.exists()) {
            throw new FileNotFoundException();
        }
        File info = this.getInfoFile();
        if (!info.isFile() || !info.exists()) {
            this.date = Util.getCreatedDate(backup);
            this.parent = null;
            this.world = "UNKNOWN";
        } else {
            BufferedReader br = new BufferedReader(new FileReader(this.getInfoFile()));
            Date date = Util.getCreatedDate(backup);
            File parent = null;
            String world = "UNKNOWN";
            while (br.ready()) {
                String line = br.readLine();
                if (line.startsWith("#")) continue;
                if (line.startsWith("date:")) {
                    line = line.substring("date:".length());
                    date = new Date(Long.parseLong(line));
                    continue;
                }
                if (line.startsWith("parent:")) {
                    if ((line = line.substring("parent:".length())).equalsIgnoreCase("null")) {
                        parent = null;
                        continue;
                    }
                    parent = new File(line);
                    continue;
                }
                if (line.startsWith("world:")) {
                    world = line = line.substring("world:".length());
                    continue;
                }
                IOHelper.printError("Found invalid backup info key: " + line);
            }
            br.close();
            this.date = date;
            this.parent = parent;
            this.world = world;
        }
    }

    @Override
    public String getWorld() {
        return this.world;
    }

    @Override
    public Date getBackupDate() {
        return this.date;
    }

    @Override
    public File getParentFile() {
        return this.parent;
    }

    private boolean isParentOf(ExistingBackupInfo info) {
        while (info != null) {
            if (info.parent != null && info.parent.equals(this.getBackupFile())) {
                return true;
            }
            info = info.getParent();
        }
        return false;
    }

    public boolean delete(File backupDir) {
        List<ExistingBackupInfo> list;
        try {
            list = BackupInfoUtil.listBackupsForWorld(backupDir, this.world);
            Collections.sort(list);
            Collections.reverse(list);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        for (ExistingBackupInfo info : list) {
            if (!this.isParentOf(info)) continue;
            info.deleteInternally();
        }
        return this.deleteInternally();
    }

    private boolean deleteInternally() {
        return this.getBackupFile().delete() & this.getInfoFile().delete();
    }
}

