/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.common.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;

public class Util {
    public static Date getModificationDate(File file) {
        return new Date(file.lastModified());
    }

    public static Date getCreatedDate(File file) throws IOException {
        BasicFileAttributes attributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        return new Date(attributes.creationTime().toMillis());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getHash(File file) throws FileNotFoundException {
        if (!file.exists()) throw new FileNotFoundException();
        if (!file.isFile()) {
            throw new FileNotFoundException();
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            new RuntimeException(e);
        }
        byte[] buffer = new byte[1024];
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            int len;
            while ((len = bis.read(buffer)) > 0) {
                md.update(buffer, 0, len);
            }
            byte[] hash = md.digest();
            bis.close();
            String string = Util.getHexValue(hash);
            return string;
        }
        catch (IOException e) {
            return "";
        }
    }

    public static String getExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        String prefix = "";
        if (filename.substring(0, index).endsWith(".tar")) {
            prefix = "tar.";
        }
        return prefix + filename.substring(index + 1);
    }

    public static void deleteFile(File file) {
        if (file.isDirectory()) {
            for (File sub : file.listFiles()) {
                Util.deleteFile(sub);
            }
            file.delete();
        }
        if (file.isFile()) {
            file.delete();
        }
    }

    private static String getHexValue(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        for (byte b : data) {
            sb.append(String.format("%02X ", b));
        }
        return sb.toString();
    }
}

