/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.mc;

import aroma1997.backup.common.plugin.BackupPlugin;
import aroma1997.backup.common.plugin.PluginLoader;
import aroma1997.backup.mc.CommandBackup;
import aroma1997.backup.mc.CommandWrapper;
import aroma1997.backup.mc.Config;
import aroma1997.backup.mc.EventListener;
import aroma1997.backup.mc.MinecraftEnv;
import aroma1997.backup.mc.ThreadBackup;
import aroma1997.core.log.LogHelper;
import aroma1997.core.util.ServerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="AromaBackup", name="AromaBackup", dependencies="required-after:Aroma1997Core", acceptedMinecraftVersions="[1.9.4]")
public class AromaBackup
implements ICommandSender {
    public Logger logger = LogHelper.genNewLogger((String)"AromaBackup");
    private Timer timer;
    private ModMetadata metadata;
    @Mod.Instance(value="AromaBackup")
    public static AromaBackup instance;
    private static final Collection<String> overridenCommands;

    @Mod.EventHandler
    public void construct(FMLConstructionEvent event) {
        new MinecraftEnv();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.metadata = event.getModMetadata();
        Config.instance.reload();
        PluginLoader.load();
        this.logger.info("Loading " + PluginLoader.getPlugins().size() + " modules.");
        for (BackupPlugin plugin : PluginLoader.getPlugins()) {
            this.logger.info("Loading module: \"" + plugin.getName() + "\".");
            plugin.load();
        }
        this.logger.info("Done loading plugins.");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.logger.info("Postloading " + PluginLoader.getPlugins().size() + " modules.");
        for (BackupPlugin plugin : PluginLoader.getPlugins()) {
            this.logger.info("Loading module: \"" + plugin.getName() + "\".");
            plugin.postLoad();
        }
        this.logger.info("Done postloading plugins.");
        MinecraftForge.EVENT_BUS.register(EventListener.class);
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        this.metadata.description = this.metadata.description + "\n " + PluginLoader.getPlugins().size() + " loaded Plugins:\n";
        boolean hasPlugins = false;
        for (BackupPlugin plugin : PluginLoader.getPlugins()) {
            if (hasPlugins) {
                this.metadata.description = ", ";
            }
            this.metadata.description = this.metadata.description + plugin.getName();
            hasPlugins = true;
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandBackup());
        ICommandManager commandManager = event.getServer().func_71187_D();
        ArrayList<CommandWrapper> added = new ArrayList<CommandWrapper>(overridenCommands.size());
        for (String string : overridenCommands) {
            ICommand command = (ICommand)commandManager.func_71555_a().get(string);
            if (command == null) continue;
            added.add(new CommandWrapper(command));
        }
        for (ICommand iCommand : added) {
            event.registerServerCommand(iCommand);
        }
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        this.setupTimerDelay(Config.instance.delay);
        if (Config.instance.onStartup) {
            ThreadBackup.startBackup(ThreadBackup.BackupType.DEFAULT);
        }
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        this.timer.cancel();
        this.logger.info("Delaying server stop to finish Backup.");
        while (ThreadBackup.isBackupRunning()) {
            try {
                EventListener.tick(new TickEvent.ServerTickEvent(TickEvent.Phase.START));
                EventListener.tick(new TickEvent.ServerTickEvent(TickEvent.Phase.END));
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public String func_70005_c_() {
        return "AromaBackup";
    }

    public boolean func_70003_b(int i, String s) {
        return true;
    }

    public World func_130014_f_() {
        return null;
    }

    public void func_145747_a(ITextComponent comp) {
        this.logger.log(Level.TRACE, comp.func_150260_c());
    }

    @NetworkCheckHandler
    public boolean checkModLists(Map<String, String> modList, Side side) {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return ServerUtil.getChatForString((String)LogHelper.getLoggerPrefix((boolean)true, (Logger)this.logger, (String)this.func_70005_c_()));
    }

    public BlockPos func_180425_c() {
        return new BlockPos(0, 0, 0);
    }

    public Vec3d func_174791_d() {
        return Vec3d.field_186680_a;
    }

    public Entity func_174793_f() {
        return null;
    }

    public boolean func_174792_t_() {
        return true;
    }

    public void func_174794_a(CommandResultStats.Type type, int amount) {
    }

    public MinecraftServer func_184102_h() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    public static String getSideString() {
        return FMLCommonHandler.instance().getSide().toString().toLowerCase();
    }

    void setupTimer(long time) {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ThreadBackup.startBackupOnSchedule();
            }
        }, new Date(time), Config.instance.delay);
    }

    void setupTimerDelay(long delay) {
        this.setupTimer(System.currentTimeMillis() + delay);
    }

    static {
        overridenCommands = Arrays.asList("save-all", "save-on", "save-off");
    }
}

