/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.mc;

import aroma1997.backup.common.compression.BackupHelper;
import aroma1997.backup.common.compression.CompressionHelper;
import aroma1997.backup.common.info.ExistingBackupInfo;
import aroma1997.backup.mc.AromaBackup;
import aroma1997.backup.mc.CommandBackupBase;
import aroma1997.backup.mc.Config;
import aroma1997.backup.mc.EventListener;
import aroma1997.backup.mc.ThreadBackup;
import aroma1997.core.command.AromaBaseCommand;
import aroma1997.core.command.AromaSubCommand;
import aroma1997.core.log.LogHelper;
import aroma1997.core.util.ServerUtil;
import aroma1997.core.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import org.apache.logging.log4j.Logger;

public class CommandBackup
extends AromaSubCommand {
    CommandBackup() {
        super(new String[]{"backup"});
        this.addSubCommand((CommandBase)new CommandReloadConfig());
        this.addSubCommand((CommandBase)new CommandReschedule());
        this.addSubCommand((CommandBase)new CommandRestoreIndividual());
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender != null && (Config.instance.allPlayers || ServerUtil.isPlayerAdmin((ICommandSender)sender));
    }

    protected List<String> addTabbCompleteOptionsSelf(MinecraftServer server, ICommandSender sender, String[] arg, BlockPos pos) {
        return Arrays.asList(ThreadBackup.BackupType.DEFAULT.toString().toLowerCase(), ThreadBackup.BackupType.FULL.toString().toLowerCase(), ThreadBackup.BackupType.INCREMENTAL.toString().toLowerCase());
    }

    protected void processCommandSelf(ICommandSender sender, String[] args) {
        ThreadBackup.BackupType type = ThreadBackup.BackupType.DEFAULT;
        if (args.length > 0) {
            for (ThreadBackup.BackupType tmp : ThreadBackup.BackupType.values()) {
                if (!tmp.toString().equalsIgnoreCase(tmp.toString())) continue;
                type = tmp;
                args = CommandBackup.getSubArgs((String[])args);
                break;
            }
        }
        if (args.length > 0) {
            ServerUtil.printCommandUsage((ICommandSender)sender, (ICommand)this);
            return;
        }
        if (ThreadBackup.startBackup(type)) {
            LogHelper.sendMessageToPlayers((Logger)AromaBackup.instance.logger, (String)I18n.func_74837_a((String)"aromabackup:command.playerstarted", (Object[])new Object[]{sender.func_70005_c_()}));
        } else {
            LogHelper.sendMessageToPlayer((Logger)AromaBackup.instance.logger, (ICommandSender)sender, (String)I18n.func_74838_a((String)"aromabackup:command.alreadyrunning"));
        }
    }

    public static class CommandRestoreIndividual
    extends CommandBackupBase {
        public CommandRestoreIndividual() {
            super("restoreFile");
        }

        @Override
        public String func_71518_a(ICommandSender sender) {
            return super.func_71518_a(sender) + " <file>";
        }

        @Override
        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
            List<String> ret = super.func_184883_a(server, sender, args, pos);
            if (args.length == 2) {
                for (Map.Entry<File, String> e : CompressionHelper.listFiles(Util.getWorldFolder()).entrySet()) {
                    String add = CompressionHelper.appendFilename(e.getValue(), e.getKey().getName());
                    if (!add.startsWith(args[1])) continue;
                    ret.add(add);
                }
            }
            return ret;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length != 2) {
                throw new CommandException("Illegal amount of arguments supplied.", new Object[0]);
            }
            ExistingBackupInfo info = this.getInfo(args[0]);
            try {
                if (!BackupHelper.restoreIndividualFile(info, new File(Util.getWorldFolder(), args[1]), args[1])) {
                    sender.func_145747_a(ServerUtil.getChatForString((String)"Could not restore that file from the backup. It#s probably not in a backup."));
                } else {
                    sender.func_145747_a(ServerUtil.getChatForString((String)"Successfully restored that file from the given backup."));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new CommandException("Something failed while restoring a file from a backup. See the server log for more information.", new Object[0]);
            }
        }
    }

    private static class CommandReschedule
    extends AromaBaseCommand {
        private CommandReschedule() {
            super(new String[]{"reschedule"});
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return ServerUtil.isPlayerAdmin((ICommandSender)sender);
        }

        public String func_71518_a(ICommandSender sender) {
            return "/backup reschedule [time milis for the next backup]";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            long time = args.length == 1 ? Long.parseLong(args[0]) : System.currentTimeMillis() + Config.instance.delay;
            EventListener.waitForServerThread();
            AromaBackup.instance.setupTimer(time);
            EventListener.releaseLock();
        }
    }

    private static class CommandReloadConfig
    extends AromaBaseCommand {
        private CommandReloadConfig() {
            super(new String[]{"reloadconfig"});
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return ServerUtil.isPlayerAdmin((ICommandSender)sender);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            Config.instance.reload();
            sender.func_145747_a(ServerUtil.getChatForString((String)"Successfully reloaded config file."));
        }
    }
}

