/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.mc;

import aroma1997.backup.mc.AromaBackup;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EventListener {
    static boolean playerOnline = false;
    private static final Object marker = new Object();
    private static volatile WaitState wait = WaitState.IDLE;

    private EventListener() {
    }

    @SubscribeEvent
    public static void login(PlayerEvent.PlayerLoggedInEvent event) {
        playerOnline = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void tick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (wait == WaitState.SERVER_WAITING) {
            try {
                Object object = marker;
                synchronized (object) {
                    EventListener.setState(WaitState.BACKUP_RUNNING);
                    AromaBackup.instance.logger.info("Server Thread suspended.");
                    while (wait != WaitState.IDLE) {
                        marker.wait();
                    }
                    AromaBackup.instance.logger.info("Server Thread released.");
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setState(WaitState state) {
        Object object = marker;
        synchronized (object) {
            wait = state;
            marker.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void waitForServerThread() {
        AromaBackup.instance.logger.info("Suspending server Thread.");
        try {
            Object object = marker;
            synchronized (object) {
                if (wait == WaitState.BACKUP_RUNNING) {
                    return;
                }
                EventListener.setState(WaitState.SERVER_WAITING);
                while (wait != WaitState.BACKUP_RUNNING) {
                    marker.wait();
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    static void releaseLock() {
        AromaBackup.instance.logger.info("Releasing server Thread.");
        EventListener.setState(WaitState.IDLE);
    }

    static enum WaitState {
        IDLE,
        SERVER_WAITING,
        BACKUP_RUNNING;

    }
}

