/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.recovery;

import aroma1997.backup.common.compression.BackupHelper;
import aroma1997.backup.common.info.BackupInfoUtil;
import aroma1997.backup.common.info.ExistingBackupInfo;
import aroma1997.backup.mc.Config;
import aroma1997.backup.recovery.GuiRestoreChunk;
import aroma1997.core.coremod.CoreMod;
import aroma1997.core.coremod.MCPNames;
import aroma1997.core.log.LogHelper;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.GuiWorldSelection;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiRestoreWorld
extends GuiScreen
implements GuiYesNoCallback {
    private static final DateFormat dateFormatter = new SimpleDateFormat();
    private static final int ID_CANCEL = 0;
    private static final int ID_RESTORE = 1;
    private static final int ID_DELETE = 2;
    private static final int ID_RESTORE_CHUNK = 3;
    static final int ID_RECREATE = 5;
    private final String worldName;
    java.util.List<ExistingBackupInfo> info;
    final GuiWorldSelection parent;
    private String title;
    public int currentSelected = -1;
    public GuiButton buttonRestore;
    private GuiButton buttonDelete;
    private List list;
    private Action action = Action.NONE;
    private GuiButton buttonRestoreChunk;
    private static final File mcdir = CoreMod.mcLocation;

    public GuiRestoreWorld(String worldName, GuiWorldSelection parent) {
        this.worldName = worldName;
        this.parent = parent;
        this.load();
    }

    private void load() {
        try {
            this.info = BackupInfoUtil.listBackupsForWorld(new File(Config.instance.location), this.worldName);
            Collections.sort(this.info);
            Collections.reverse(this.info);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadBackup(int id) throws IOException {
        File oldWorld = new File(mcdir, "saves/" + this.worldName);
        File file = new File(mcdir, "saves/" + this.worldName + "_old");
        while (file.exists()) {
            file = new File(file.getCanonicalPath() + "_old");
        }
        Files.move((File)oldWorld, (File)file);
        BackupHelper.restoreBackup(this.info.get(id), oldWorld);
        Minecraft.func_71410_x().func_147108_a((GuiScreen)this.parent);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.title = I18n.func_74837_a((String)"aromabackuprecovery:selectBackup.select", (Object[])new Object[]{this.worldName});
        this.list = new List(this.field_146297_k);
        this.list.func_148134_d(4, 5);
        this.buttonRestore = new GuiButton(1, this.field_146294_l / 2 - 154, this.field_146295_m - 52, 150, 20, I18n.func_74838_a((String)"aromabackuprecovery:selectBackup.select"));
        this.field_146292_n.add(this.buttonRestore);
        this.buttonDelete = new GuiButton(2, this.field_146294_l / 2 - 154, this.field_146295_m - 28, 150, 20, I18n.func_74838_a((String)"selectWorld.delete"));
        this.field_146292_n.add(this.buttonDelete);
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 + 82, this.field_146295_m - 28, 72, 20, I18n.func_74838_a((String)"gui.cancel")));
        this.buttonRestoreChunk = new GuiButton(3, this.field_146294_l / 2 + 4, this.field_146295_m - 52, 150, 20, I18n.func_74838_a((String)"aromabackuprecovery:restorechunk.button"));
        this.field_146292_n.add(this.buttonRestoreChunk);
        this.field_146292_n.add(new GuiButton(5, this.field_146294_l / 2 + 4, this.field_146295_m - 28, 72, 20, I18n.func_74838_a((String)"selectWorld.recreate")));
        this.buttonRestore.field_146124_l = false;
        this.buttonDelete.field_146124_l = false;
        this.buttonRestoreChunk.field_146124_l = false;
        this.currentSelected = -1;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            if (button.field_146127_k == 2) {
                this.action = Action.DELETE;
                this.field_146297_k.func_147108_a(this.getGuiYesNo());
            } else if (button.field_146127_k == 1) {
                this.action = Action.RESTORE;
                this.field_146297_k.func_147108_a(this.getGuiYesNo());
            } else if (button.field_146127_k == 0) {
                this.field_146297_k.func_147108_a((GuiScreen)this.parent);
            } else if (button.field_146127_k == 3) {
                if (this.currentSelected != -1) {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiRestoreChunk(this, this.info.get(this.currentSelected)));
                }
            } else if (button.field_146127_k == 5) {
                try {
                    ReflectionHelper.findMethod(GuiWorldSelection.class, (Object)this.parent, (String[])new String[]{MCPNames.method((String)"func_146284_a")}, (Class[])new Class[]{GuiButton.class}).invoke((Object)this.parent, button);
                }
                catch (Throwable t) {
                    LogHelper.logException((String)"Could not re-create World...", (Throwable)t);
                }
            } else {
                this.list.func_148147_a(button);
            }
        } else {
            super.func_146284_a(button);
        }
    }

    public void func_73878_a(boolean result, int id) {
        GuiRestoreWorld screen;
        if (result) {
            switch (this.action) {
                case DELETE: {
                    ExistingBackupInfo backupInfo = this.info.get(this.currentSelected);
                    backupInfo.delete(new File(Config.instance.location));
                    screen = this;
                    break;
                }
                case RESTORE: {
                    try {
                        this.loadBackup(this.currentSelected);
                        screen = this.parent;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        screen = new GuiErrorScreen(I18n.func_74838_a((String)"aromabackuprecovery:restoreBackup.error.1"), I18n.func_74838_a((String)"aromabackuprecovery:restoreBackup.error.2"));
                    }
                    break;
                }
                default: {
                    screen = this;
                }
            }
            this.action = Action.NONE;
        } else {
            screen = this;
        }
        this.field_146297_k.func_147108_a((GuiScreen)screen);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.list.func_148128_a(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 20, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public GuiScreen getGuiYesNo() {
        ExistingBackupInfo backupInfo = this.info.get(this.currentSelected);
        GuiYesNo screen = null;
        switch (this.action) {
            case DELETE: {
                screen = new GuiYesNo((GuiYesNoCallback)this, I18n.func_74838_a((String)"aromabackuprecovery:deleteBackup.question"), I18n.func_74837_a((String)"aromabackuprecovery:deleteBackup.info", (Object[])new Object[]{backupInfo.getBackupFile().getName()}), I18n.func_74838_a((String)"selectWorld.deleteButton"), I18n.func_74838_a((String)"gui.cancel"), 0);
                break;
            }
            case RESTORE: {
                screen = new GuiYesNo((GuiYesNoCallback)this, I18n.func_74838_a((String)"aromabackuprecovery:restoreBackup.question"), I18n.func_74837_a((String)"aromabackuprecovery:restoreBackup.info", (Object[])new Object[]{this.worldName, this.worldName + "_old"}), I18n.func_74838_a((String)"aromabackuprecovery:selectBackup.select"), I18n.func_74838_a((String)"gui.cancel"), 0);
                break;
            }
        }
        return screen;
    }

    java.util.List<GuiButton> getButtonList() {
        return this.field_146292_n;
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.list.func_178039_p();
    }

    private static enum Action {
        NONE,
        RESTORE,
        DELETE;

    }

    @SideOnly(value=Side.CLIENT)
    class List
    extends GuiSlot {
        public List(Minecraft mcIn) {
            super(mcIn, GuiRestoreWorld.this.field_146294_l, GuiRestoreWorld.this.field_146295_m, 32, GuiRestoreWorld.this.field_146295_m - 64, 24);
        }

        protected int func_148127_b() {
            return GuiRestoreWorld.this.info.size();
        }

        protected void func_148144_a(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
            boolean flag1;
            GuiRestoreWorld.this.currentSelected = slotIndex;
            GuiRestoreWorld.this.buttonRestore.field_146124_l = flag1 = GuiRestoreWorld.this.currentSelected >= 0 && GuiRestoreWorld.this.currentSelected < this.func_148127_b();
            ((GuiRestoreWorld)GuiRestoreWorld.this).buttonDelete.field_146124_l = flag1;
            ((GuiRestoreWorld)GuiRestoreWorld.this).buttonRestoreChunk.field_146124_l = flag1;
        }

        protected boolean func_148131_a(int slotIndex) {
            return slotIndex == GuiRestoreWorld.this.currentSelected;
        }

        protected int func_148138_e() {
            return GuiRestoreWorld.this.info.size() * this.field_148149_f;
        }

        protected void func_148123_a() {
            GuiRestoreWorld.this.func_146276_q_();
        }

        protected void func_180791_a(int entryID, int x, int y, int p_180791_4_, int mouseXIn, int mouseYIn) {
            ExistingBackupInfo backupInfo = GuiRestoreWorld.this.info.get(entryID);
            GuiRestoreWorld.this.func_73731_b(GuiRestoreWorld.this.field_146289_q, I18n.func_74837_a((String)"aromabackuprecovery:selectBackup.name", (Object[])new Object[]{backupInfo.getWorld(), dateFormatter.format(backupInfo.getBackupDate())}), x + 2, y, 0xFFFFFF);
            if (backupInfo.isIncremental()) {
                GuiRestoreWorld.this.func_73731_b(GuiRestoreWorld.this.field_146289_q, "(I)", x + 215, y, 0xFFFFFF);
            }
            GuiRestoreWorld.this.func_73731_b(GuiRestoreWorld.this.field_146289_q, backupInfo.getBackupFile().getName(), x + 2, y + 12, 0x808080);
        }
    }
}

