/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.recovery;

import aroma1997.backup.common.compression.BackupHelper;
import aroma1997.backup.common.info.ExistingBackupInfo;
import aroma1997.backup.common.util.Environment;
import java.io.File;
import java.io.IOException;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RestoreChunkInfo {
    private int x;
    private int z;
    private ExistingBackupInfo info;

    public RestoreChunkInfo(int x, int z, ExistingBackupInfo binfo) {
        this.x = x;
        this.z = z;
        this.info = binfo;
    }

    public boolean matches(int x, int z) {
        return x == this.x && z == this.z;
    }

    public File getFile() {
        File file = Environment.getEnv().getTmpDir(this.info.getBackupFile().getName());
        if (!file.exists() || !file.isDirectory()) {
            try {
                BackupHelper.restoreBackup(this.info, file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new File(file, this.info.getWorld());
    }
}

