/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.standalone.command;

import aroma1997.backup.common.util.IOHelper;
import aroma1997.backup.standalone.command.CommandException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public abstract class Command {
    private final String name;
    private final Collection<String> aliases;

    public Command(String ... name) {
        if (name.length == 0) {
            String className = this.getClass().getSimpleName().toLowerCase();
            this.name = className.startsWith("command") ? className.substring("command".length()) : className;
            this.aliases = Collections.emptySet();
        } else if (name.length == 1) {
            this.name = name[0];
            this.aliases = Collections.emptySet();
        } else {
            this.name = name[0];
            this.aliases = new ArrayList<String>();
            for (int i = 1; i < name.length; ++i) {
                this.aliases.add(name[i].toLowerCase());
            }
        }
    }

    public String getDescr() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public Collection<String> getCommandAliases() {
        return this.aliases;
    }

    public abstract void execute(String[] var1) throws CommandException;

    public void printCommandUsage() {
        IOHelper.printUserOut(this.getDescr());
    }
}

