/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.standalone.commands;

import aroma1997.backup.common.info.BackupInfoUtil;
import aroma1997.backup.common.info.ExistingBackupInfo;
import aroma1997.backup.common.util.Environment;
import aroma1997.backup.common.util.IOHelper;
import aroma1997.backup.standalone.Main;
import aroma1997.backup.standalone.command.Command;
import aroma1997.backup.standalone.command.CommandException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class CommandList
extends Command {
    public CommandList() {
        super("list");
    }

    @Override
    public void execute(String[] args) throws CommandException {
        IOHelper.printUserOut("Incremental backups are marked with a (I)");
        IOHelper.printUserOut("The following backups were found at " + Environment.getEnv().getBackupDir());
        try {
            List<ExistingBackupInfo> backups = Main.env.getWorldName() == null ? BackupInfoUtil.listBackups(Environment.getEnv().getBackupDir()) : BackupInfoUtil.listBackupsForWorld(Environment.getEnv().getBackupDir(), Main.env.getWorldName());
            Collections.sort(backups);
            for (ExistingBackupInfo info : backups) {
                IOHelper.printUserOut(info.getBackupDate() + ": " + info.getBackupFile().getCanonicalPath() + (info.isIncremental() ? " (I)" : ""));
            }
            IOHelper.printUserOut("");
        }
        catch (IOException e) {
            IOHelper.printUserOut("Failed to list backups.");
            e.printStackTrace();
        }
    }
}

