/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.authentication;

import java.net.URL;
import net.minecraft.launcher.LauncherConstants;
import net.minecraft.launcher.authentication.BaseAuthenticationService;
import net.minecraft.launcher.authentication.GameProfile;
import net.minecraft.launcher.authentication.exceptions.AuthenticationException;

public class LegacyAuthenticationService
extends BaseAuthenticationService {
    private static final URL AUTHENTICATION_URL = LauncherConstants.constantURL("https://login.minecraft.net");
    private static final int AUTHENTICATION_VERSION = 14;
    private static final int RESPONSE_PART_PROFILE_NAME = 2;
    private static final int RESPONSE_PART_SESSION_TOKEN = 3;
    private static final int RESPONSE_PART_PROFILE_ID = 4;
    private String sessionToken = null;

    @Override
    public void logIn() throws AuthenticationException {
        this.setSelectedProfile(new GameProfile("id", this.getUsername()));
        this.sessionToken = "SessionToken";
        this.fireAuthenticationChangedEvent();
    }

    @Override
    public void logOut() {
        super.logOut();
        this.sessionToken = null;
        this.fireAuthenticationChangedEvent();
    }

    @Override
    public GameProfile[] getAvailableProfiles() {
        if (this.getSelectedProfile() != null) {
            return new GameProfile[]{this.getSelectedProfile()};
        }
        return new GameProfile[0];
    }

    @Override
    public void selectGameProfile(GameProfile profile) throws AuthenticationException {
        throw new UnsupportedOperationException("Game profiles cannot be changed in the legacy authentication service");
    }

    @Override
    public String getSessionToken() {
        return this.sessionToken;
    }
}

