/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.popups.profile;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.minecraft.launcher.OperatingSystem;
import net.minecraft.launcher.ui.popups.profile.ProfileEditorPopup;

public class ProfileJavaPanel
extends JPanel {
    private final ProfileEditorPopup editor;
    private final JCheckBox javaPathCustom = new JCheckBox("\u0418\u0441\u043f\u043e\u043b\u043d\u044f\u0435\u043c\u044b\u0439 \u0444\u0430\u0439\u043b:");
    private final JTextField javaPathField = new JTextField();
    private final JCheckBox javaArgsCustom = new JCheckBox("\u0410\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b:");
    private final JTextField javaArgsField = new JTextField();

    public ProfileJavaPanel(ProfileEditorPopup editor) {
        this.editor = editor;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 Java"));
        this.createInterface();
        this.fillDefaultValues();
        this.addEventHandlers();
    }

    protected void createInterface() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.anchor = 17;
        constraints.gridy = 0;
        this.add((Component)this.javaPathCustom, constraints);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        this.add((Component)this.javaPathField, constraints);
        constraints.weightx = 0.0;
        constraints.fill = 0;
        ++constraints.gridy;
        this.add((Component)this.javaArgsCustom, constraints);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        this.add((Component)this.javaArgsField, constraints);
        constraints.weightx = 0.0;
        constraints.fill = 0;
        ++constraints.gridy;
    }

    protected void fillDefaultValues() {
        String javaPath = this.editor.getProfile().getJavaPath();
        if (javaPath != null) {
            this.javaPathCustom.setSelected(true);
            this.javaPathField.setText(javaPath);
        } else {
            this.javaPathCustom.setSelected(false);
            this.javaPathField.setText(OperatingSystem.getCurrentPlatform().getJavaDir());
        }
        this.updateJavaPathState();
        String args = this.editor.getProfile().getJavaArgs();
        if (args != null) {
            this.javaArgsCustom.setSelected(true);
            this.javaArgsField.setText(args);
        } else {
            this.javaArgsCustom.setSelected(false);
            this.javaArgsField.setText("-Xmx1G");
        }
        this.updateJavaArgsState();
    }

    protected void addEventHandlers() {
        this.javaPathCustom.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ProfileJavaPanel.this.updateJavaPathState();
            }
        });
        this.javaPathField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProfileJavaPanel.this.updateJavaPath();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ProfileJavaPanel.this.updateJavaPath();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ProfileJavaPanel.this.updateJavaPath();
            }
        });
        this.javaArgsCustom.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ProfileJavaPanel.this.updateJavaArgsState();
            }
        });
        this.javaArgsField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProfileJavaPanel.this.updateJavaArgs();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ProfileJavaPanel.this.updateJavaArgs();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ProfileJavaPanel.this.updateJavaArgs();
            }
        });
    }

    private void updateJavaPath() {
        if (this.javaPathCustom.isSelected()) {
            this.editor.getProfile().setJavaDir(this.javaPathField.getText());
        } else {
            this.editor.getProfile().setJavaDir(null);
        }
    }

    private void updateJavaPathState() {
        if (this.javaPathCustom.isSelected()) {
            this.javaPathField.setEnabled(true);
            this.editor.getProfile().setJavaDir(this.javaPathField.getText());
        } else {
            this.javaPathField.setEnabled(false);
            this.editor.getProfile().setJavaDir(null);
        }
    }

    private void updateJavaArgs() {
        if (this.javaArgsCustom.isSelected()) {
            this.editor.getProfile().setJavaArgs(this.javaArgsField.getText());
        } else {
            this.editor.getProfile().setJavaArgs(null);
        }
    }

    private void updateJavaArgsState() {
        if (this.javaArgsCustom.isSelected()) {
            this.javaArgsField.setEnabled(true);
            this.editor.getProfile().setJavaArgs(this.javaArgsField.getText());
        } else {
            this.javaArgsField.setEnabled(false);
            this.editor.getProfile().setJavaArgs(null);
        }
    }
}

