/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.tabs;

import java.awt.Component;
import javax.swing.JTabbedPane;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.ui.tabs.ConsoleTab;
import net.minecraft.launcher.ui.tabs.CrashReportTab;
import net.minecraft.launcher.ui.tabs.ProfileListTab;
import net.minecraft.launcher.ui.tabs.VersionListTab;
import net.minecraft.launcher.ui.tabs.WebsiteTab;

public class LauncherTabPanel
extends JTabbedPane {
    private final Launcher launcher;
    private final WebsiteTab blog;
    private final ConsoleTab console;
    private CrashReportTab crashReportTab;

    public LauncherTabPanel(Launcher launcher) {
        super(1);
        this.launcher = launcher;
        this.blog = new WebsiteTab(launcher);
        this.console = new ConsoleTab(launcher);
        this.createInterface();
    }

    protected void createInterface() {
        this.addTab("\u041d\u043e\u0432\u043e\u0441\u0442\u0438", this.blog);
        this.addTab("\u041a\u043e\u043d\u0441\u043e\u043b\u044c", this.console);
        this.addTab("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0440\u043e\u0444\u0438\u043b\u0435\u0439", new ProfileListTab(this.launcher));
        this.addTab("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0432\u0435\u0440\u0441\u0438\u0439", new VersionListTab(this.launcher));
    }

    public Launcher getLauncher() {
        return this.launcher;
    }

    public WebsiteTab getBlog() {
        return this.blog;
    }

    public ConsoleTab getConsole() {
        return this.console;
    }

    public void showConsole() {
        this.setSelectedComponent(this.console);
    }

    public void setCrashReport(CrashReportTab newTab) {
        if (this.crashReportTab != null) {
            this.removeTab(this.crashReportTab);
        }
        this.crashReportTab = newTab;
        this.addTab("Crash Report", this.crashReportTab);
        this.setSelectedComponent(newTab);
    }

    protected void removeTab(Component tab) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (this.getTabComponentAt(i) != tab) continue;
            this.removeTabAt(i);
            break;
        }
    }
}

