/*
 * Decompiled with CFR 0.152.
 */
package org.spara.mol;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import net.minecraft.launcher.Launcher;

public class InstallDirSettings {
    public static File loadAtStartup(JFrame frame, File defaultWorkingDir) {
        File workingDirectory;
        Properties prop = new Properties();
        File file = new File("./MOL_Properties.properties");
        if (!file.exists()) {
            workingDirectory = InstallDirSettings.changeDirInternal(frame, defaultWorkingDir, prop, file);
        } else {
            try {
                prop.load(new FileInputStream(file));
            }
            catch (IOException ex) {
                Logger.getLogger(Launcher.class.getName()).log(Level.SEVERE, null, ex);
            }
            workingDirectory = new File(prop.getProperty("installation_dir"));
        }
        return workingDirectory;
    }

    public static File changeDir(JFrame frame, File currentWorkingDir) {
        Properties prop = new Properties();
        File file = new File("./MOL_Properties.properties");
        return InstallDirSettings.changeDirInternal(frame, currentWorkingDir, prop, file);
    }

    private static File changeDirInternal(JFrame frame, File currentWorkingDir, Properties prop, File settingFile) {
        File workingDirectory = new File(currentWorkingDir.getAbsolutePath());
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        fileChooser.setDialogTitle("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u043f\u043a\u0443, \u0432 \u043a\u043e\u0442\u043e\u0440\u0443\u044e \u0431\u0443\u0434\u0435\u0442 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0438\u0433\u0440\u0430:");
        int ret = fileChooser.showOpenDialog(frame);
        if (ret == 0) {
            File dir = fileChooser.getSelectedFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            prop.setProperty("installation_dir", dir.getAbsolutePath());
            workingDirectory = dir;
        } else if (ret == 1) {
            prop.setProperty("installation_dir", workingDirectory.getAbsolutePath());
        }
        try {
            prop.store(new FileOutputStream(settingFile), "");
        }
        catch (IOException ex) {
            Logger.getLogger(Launcher.class.getName()).log(Level.SEVERE, null, ex);
        }
        JOptionPane.showMessageDialog(frame, "Minecraft \u0431\u0443\u0434\u0435\u0442 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0432 \u043f\u0430\u043f\u043a\u0443 " + workingDirectory.getAbsolutePath() + "\r\n\u0421\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0430\u043f\u043a\u0443 \u043c\u043e\u0436\u043d\u043e, \u043d\u0430\u0436\u0430\u0432 \u043d\u0430 \"\u041f\u0430\u043f\u043a\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438\" \u0432 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0435.");
        return workingDirectory;
    }
}

