/*
 * Decompiled with CFR 0.152.
 */
package org.spara.mol;

import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import javax.swing.JFrame;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import net.minecraft.launcher.Launcher;
import org.spara.mol.Util;

public class Main {
    public static void main(String[] args) throws IOException {
        File workingDirectory;
        OptionSet optionSet;
        System.setProperty("java.net.preferIPv4Stack", "true");
        OptionParser optionParser = new OptionParser();
        optionParser.allowsUnrecognizedOptions();
        optionParser.accepts("help", "Show help").forHelp();
        optionParser.accepts("force", "Force updating");
        ArgumentAcceptingOptionSpec<String> proxyHostOption = optionParser.accepts("proxyHost", "Optional").withRequiredArg();
        ArgumentAcceptingOptionSpec<Integer> proxyPortOption = optionParser.accepts("proxyPort", "Optional").withRequiredArg().defaultsTo("8080", (String[])new String[0]).ofType(Integer.class);
        ArgumentAcceptingOptionSpec<String> proxyUserOption = optionParser.accepts("proxyUser", "Optional").withRequiredArg();
        ArgumentAcceptingOptionSpec<String> proxyPassOption = optionParser.accepts("proxyPass", "Optional").withRequiredArg();
        ArgumentAcceptingOptionSpec<File> workingDirectoryOption = optionParser.accepts("workdir", "Optional").withRequiredArg().ofType(File.class).defaultsTo(Util.getWorkingDirectory(), (File[])new File[0]);
        NonOptionArgumentSpec<String> nonOptions = optionParser.nonOptions();
        try {
            optionSet = optionParser.parse(args);
        }
        catch (OptionException e) {
            optionParser.printHelpOn(System.out);
            System.out.println("(to pass in arguments to minecraft directly use: '--' followed by your arguments");
            return;
        }
        if (optionSet.has("help")) {
            optionParser.printHelpOn(System.out);
            return;
        }
        String hostName = optionSet.valueOf(proxyHostOption);
        Proxy proxy = Proxy.NO_PROXY;
        if (hostName != null) {
            try {
                proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(hostName, (int)optionSet.valueOf(proxyPortOption)));
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        String proxyUser = optionSet.valueOf(proxyUserOption);
        String proxyPass = optionSet.valueOf(proxyPassOption);
        PasswordAuthentication passwordAuthentication = null;
        if (!proxy.equals(Proxy.NO_PROXY) && Main.stringHasValue(proxyUser) && Main.stringHasValue(proxyPass)) {
            final PasswordAuthentication auth = passwordAuthentication = new PasswordAuthentication(proxyUser, proxyPass.toCharArray());
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return auth;
                }
            });
        }
        if ((workingDirectory = optionSet.valueOf(workingDirectoryOption)).exists() && !workingDirectory.isDirectory()) {
            throw new RuntimeException("Invalid working directory: " + workingDirectory);
        }
        if (!workingDirectory.exists() && !workingDirectory.mkdirs()) {
            throw new RuntimeException("Unable to create directory: " + workingDirectory);
        }
        JFrame frame = new JFrame();
        new Launcher(frame, workingDirectory, proxy, passwordAuthentication, args);
    }

    public static boolean stringHasValue(String string) {
        return string != null && !string.isEmpty();
    }
}

